///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the ASCII Format exporter plug-in for Flexporter.
 *	\file		IceASCIIExporter.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEASCIIEXPORTER_H__
#define __ICEASCIIEXPORTER_H__

	class ASCIIFormat : public ExportFormat
	{
	public:
	// Constructor/Destructor
										ASCIIFormat();
		virtual							~ASCIIFormat();

	// Exporter init
		virtual	bool					Init(bool motion);

	// Main scene info
		virtual bool					SetSceneInfo		(const MainDescriptor& maininfo);

	// Export loop
				bool					ExportBasicInfo		(const ObjectDescriptor* obj, CustomArray* array);

		virtual bool					ExportCamera		(const CameraDescriptor& camera);
		virtual bool					ExportController	(const ControllerDescriptor& controller);
		virtual bool					ExportHelper		(const HelperDescriptor& helper);
		virtual bool					ExportLight			(const LightDescriptor& light);
		virtual bool					ExportMaterial		(const MaterialDescriptor& material);
		virtual bool					ExportMesh			(const MeshDescriptor& mesh);
		virtual bool					ExportMotion		(const MotionDescriptor& motion);
		virtual bool					ExportShape			(const ShapeDescriptor& shape);
		virtual bool					ExportTexture		(const TextureDescriptor& texture);

	// End of export notification
		virtual bool					EndExport			(const StatsDescriptor& stats);

	private:
	// Time info local copy
				MAXTimeInfo				mTimeInfo;
	// Export arrays
				CustomArray				mGeneral;
				CustomArray				mGeomObjects;
				CustomArray				mCameras;
				CustomArray				mLights;
				CustomArray				mShapes;
				CustomArray				mHelpers;
				CustomArray				mTexmaps;
				CustomArray				mMaterials;
				CustomArray				mControllers;
				CustomArray				mMotion;
	// Flags
				bool					mIsMotionFile;
	};

#endif // __ICEASCIIEXPORTER_H__
